<?php
 /**
 * @package Stripe Editor Button System plugin
 * @author Riccardo Zorn code@fasterjoomla.com
 * @copyright (C) 2018 - 2019 https://www.fasterjoomla.com
 * @license GNU/GPL v2 or greater http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

JLoader::import('joomla.plugin.plugin');

/**
 * Editor STRIPE button
 */
class plgButtonStripe_xtd extends JPlugin
{

	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}


	/**
	 * Display the button
	 *
	 * @return the $button object)
	 */
	function onDisplay($name)
	{
		/*
		 * Javascript to insert the shortcode
		 */
		$js = "
		function insertStripe(formattedStripe) {
			var tag = '<div>'+formattedStripe+'</div>';
			jInsertEditorText(tag, '".$name."');
			SqueezeBox.close();
		}
		function closeBox() {
			SqueezeBox.close();
		}

		";

		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration($js);

		$doc->addStyleDeclaration('.icon-stripe {
			background: url(/plugins/system/stripe_button/assets/images/s14.png) !important;
			background-repeat: no-repeat !important;
			
		}');

		$app = JFactory::getApplication();
		$tmpl = $app->getTemplate();
		$doc->addStyleDeclaration(".button2-left .arsitem {background: url(templates/$tmpl/images/j_button2_readmore.png) 100% 0 no-repeat;}");

		JHtml::_('behavior.modal');

		/*
		 * Use the built-in element view to select the article.
		 * Currently uses blank class.
		 */
		$link = '../plugins/editors-xtd/stripe_xtd/modal.html';
 		
		$button = new JObject();
		$button->set('modal', true);
		$button->set('class', 'btn');
		$button->set('link', $link);
		$button->set('text', 'STRIPE');//JText::_('PLG_STRIPE_BUTTON_TEXT'));
		$button->set('name', 'stripe');
		$button->set('options', "{handler: 'iframe', size: {x: 770, y: 400}}");
		return $button;
	}
}
